/*
 * Decompiled with CFR 0.152.
 */
package carpet;

import carpet.CarpetServer;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.Validator;
import carpet.api.settings.Validators;
import carpet.script.utils.AppStoreManager;
import carpet.settings.Rule;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import carpet.utils.SpawnChunks;
import carpet.utils.Translations;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_2994;
import net.minecraft.class_3176;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarpetSettings {
    public static final String carpetVersion = "1.4.84+v221018";
    public static final Logger LOG = LoggerFactory.getLogger((String)"carpet");
    public static final ThreadLocal<Boolean> skipGenerationChecks = ThreadLocal.withInitial(() -> false);
    public static final ThreadLocal<Boolean> impendingFillSkipUpdates = ThreadLocal.withInitial(() -> false);
    public static int runPermissionLevel = 2;
    public static boolean doChainStone = false;
    public static boolean chainStoneStickToAll = false;
    public static class_2248 structureBlockIgnoredBlock = class_2246.field_10369;
    public static final int vanillaStructureBlockLimit = 48;
    @Rule(desc="Sets the language for Carpet", category={"feature"}, options={"en_us", "zh_cn", "zh_tw"}, strict=true, validate={LanguageValidator.class})
    public static String language = "en_us";
    @Rule(desc="Carpet command permission level. Can only be set via .conf file", category={"creative"}, validate={CarpetPermissionLevel.class}, options={"ops", "2", "4"})
    public static String carpetCommandPermissionLevel = "ops";
    @Rule(desc="Gbhs sgnf sadsgras fhskdpri!!!", category={"experimental"})
    public static boolean superSecretSetting = false;
    @Rule(desc="Amount of delay ticks to use a nether portal in creative", options={"1", "40", "80", "72000"}, category={"creative"}, strict=false, validate={OneHourMaxDelayLimit.class})
    public static int portalCreativeDelay = 1;
    @Rule(desc="Amount of delay ticks to use a nether portal in survival", options={"1", "40", "80", "72000"}, category={"survival"}, strict=false, validate={OneHourMaxDelayLimit.class})
    public static int portalSurvivalDelay = 80;
    @Rule(desc="Dropping entire stacks works also from on the crafting UI result slot", category={"bugfix", "survival"})
    public static boolean ctrlQCraftingFix = false;
    @Rule(desc="Parrots don't get of your shoulders until you receive proper damage", category={"survival", "feature"})
    public static boolean persistentParrots = false;
    @Rule(desc="Players absorb XP instantly, without delay", category={"creative"})
    public static boolean xpNoCooldown = false;
    @Rule(desc="Empty shulker boxes can stack when thrown on the ground.", extra={".. or when manipulated inside the inventories"}, validate={StackableShulkerBoxValidator.class}, options={"false", "true", "16"}, strict=false, category={"survival", "feature"})
    public static String stackableShulkerBoxes = "false";
    public static int shulkerBoxStackSize = 1;
    @Rule(desc="Explosions won't destroy blocks", category={"creative", "tnt"})
    public static boolean explosionNoBlockDamage = false;
    @Rule(desc="Experience will drop from all experience barring blocks with any explosion type", category={"survival", "feature"})
    public static boolean xpFromExplosions = false;
    @Rule(desc="Removes random TNT momentum when primed", category={"creative", "tnt"})
    public static boolean tntPrimerMomentumRemoved = false;
    @Rule(desc="TNT causes less lag when exploding in the same spot and in liquids", category={"tnt"})
    public static boolean optimizedTNT = false;
    @Rule(desc="Sets the tnt random explosion range to a fixed value", category={"tnt"}, options={"-1"}, strict=false, validate={CheckOptimizedTntEnabledValidator.class, TNTRandomRangeValidator.class}, extra={"Set to -1 for default behavior"})
    public static double tntRandomRange = -1.0;
    @Rule(desc="Sets the horizontal random angle on TNT for debugging of TNT contraptions", category={"tnt"}, options={"-1"}, strict=false, validate={TNTAngleValidator.class}, extra={"Set to -1 for default behavior"})
    public static double hardcodeTNTangle = -1.0;
    @Rule(desc="Merges stationary primed TNT entities", category={"tnt"})
    public static boolean mergeTNT = false;
    @Rule(desc="Lag optimizations for redstone dust", extra={"by Theosib", ".. also fixes some locational behaviours or vanilla redstone MC-11193", "so behaviour of locational vanilla contraptions is not guaranteed"}, category={"experimental", "optimization"})
    public static boolean fastRedstoneDust = false;
    @Rule(desc="Only husks spawn in desert temples", category={"feature"})
    public static boolean huskSpawningInTemples = false;
    @Rule(desc="Shulkers will respawn in end cities", category={"feature"})
    public static boolean shulkerSpawningInEndCities = false;
    @Rule(desc="Piglins will respawn in bastion remnants", extra={"Includes piglins, brutes, and a few hoglins"}, category={"feature"})
    public static boolean piglinsSpawningInBastions = false;
    @Rule(desc="TNT doesn't update when placed against a power source", category={"creative", "tnt"})
    public static boolean tntDoNotUpdate = false;
    @Rule(desc="Prevents players from rubberbanding when moving too fast", extra={"... or being kicked out for 'flying'", "Puts more trust in clients positioning", "Increases player allowed mining distance to 32 blocks"}, category={"creative", "survival"})
    public static boolean antiCheatDisabled = false;
    @Rule(desc="Pistons, droppers and dispensers react if block above them is powered", category={"creative"})
    public static boolean quasiConnectivity = true;
    @Rule(desc="Players can flip and rotate blocks when holding cactus", extra={"Doesn't cause block updates when rotated/flipped", "Applies to pistons, observers, droppers, repeaters, stairs, glazed terracotta etc..."}, category={"creative", "survival", "feature"})
    public static boolean flippinCactus = false;
    @Rule(desc="hoppers pointing to wool will count items passing through them", extra={"Enables /counter command, and actions while placing red and green carpets on wool blocks", "Use /counter <color?> reset to reset the counter, and /counter <color?> to query", "In survival, place green carpet on same color wool to query, red to reset the counters", "Counters are global and shared between players, 16 channels available", "Items counted are destroyed, count up to one stack per tick per hopper"}, category={"command", "creative", "feature"})
    public static boolean hopperCounters = false;
    @Rule(desc="Allows Budding Amethyst blocks to be moved", extra={"Allow for them to be moved by pistons", "as well as adds extra drop when mining with silk touch pickaxe"}, category={"feature"})
    public static boolean movableAmethyst = false;
    @Rule(desc="Guardians turn into Elder Guardian when struck by lightning", category={"feature"})
    public static boolean renewableSponges = false;
    @Rule(desc="Pistons can push block entities, like hoppers, chests etc.", category={"experimental", "feature"})
    public static boolean movableBlockEntities = false;
    @Rule(desc="Chains will stick to each other on the long ends", extra={"and will stick to other blocks that connect to them directly.", "With stick_to_all: it will stick even if not visually connected"}, category={"experimental", "feature"}, options={"true", "false", "stick_to_all"}, validate={ChainStoneSetting.class})
    public static String chainStone = "false";
    @Rule(desc="Saplings turn into dead shrubs in hot climates and no water access", category={"feature"})
    public static boolean desertShrubs = false;
    @Rule(desc="Silverfish drop a gravel item when breaking out of a block", category={"feature"})
    public static boolean silverFishDropGravel = false;
    @Rule(desc="summoning a lightning bolt has all the side effects of natural lightning", category={"creative"})
    public static boolean summonNaturalLightning = false;
    @Rule(desc="Enables /spawn command for spawn tracking", category={"command"})
    public static String commandSpawn = "ops";
    @Rule(desc="Enables /tick command to control game clocks", category={"command"})
    public static String commandTick = "ops";
    @Rule(desc="Enables /profile command to monitor game performance", extra={"subset of /tick command capabilities"}, category={"command"})
    public static String commandProfile = "true";
    @Rule(desc="Required permission level for /perf command", options={"2", "4"}, category={"creative"})
    public static int perfPermissionLevel = 4;
    @Rule(desc="Enables /log command to monitor events via chat and overlays", category={"command"})
    public static String commandLog = "true";
    @Rule(desc="sets these loggers in their default configurations for all new players", extra={"use csv, like 'tps,mobcaps' for multiple loggers, none for nothing"}, category={"creative", "survival"}, options={"none", "tps", "mobcaps,tps"}, strict=false)
    public static String defaultLoggers = "none";
    @Rule(desc="Enables /distance command to measure in game distance between points", extra={"Also enables brown carpet placement action if 'carpets' rule is turned on as well"}, category={"command"})
    public static String commandDistance = "true";
    @Rule(desc="Enables /info command for blocks", extra={"Also enables gray carpet placement action", "if 'carpets' rule is turned on as well"}, category={"command"})
    public static String commandInfo = "true";
    @Rule(desc="Enables /perimeterinfo command", extra={"... that scans the area around the block for potential spawnable spots"}, category={"command"})
    public static String commandPerimeterInfo = "true";
    @Rule(desc="Enables /draw commands", extra={"... allows for drawing simple shapes or", "other shapes which are sorta difficult to do normally"}, category={"command"})
    public static String commandDraw = "ops";
    @Rule(desc="Enables /script command", extra={"An in-game scripting API for Scarpet programming language"}, category={"command", "scarpet"})
    public static String commandScript = "true";
    @Rule(desc="Enables restrictions for arbitrary code execution with scarpet", extra={"Users that don't have this permission level", "won't be able to load apps or /script run.", "It is also the permission level apps will", "have when running commands with run()"}, category={"scarpet"}, options={"ops", "0", "1", "2", "3", "4"}, validate={Validators.CommandLevel.class, ModulePermissionLevel.class})
    public static String commandScriptACE = "ops";
    @Rule(desc="Scarpet script from world files will autoload on server/world start ", extra={"if /script is enabled"}, category={"scarpet"})
    public static boolean scriptsAutoload = true;
    @Rule(desc="Enables scripts debugging messages in system log", category={"scarpet"})
    public static boolean scriptsDebugging = false;
    @Rule(desc="Enables scripts optimization", category={"scarpet"})
    public static boolean scriptsOptimization = true;
    @Rule(desc="Location of the online repository of scarpet apps", extra={"set to 'none' to disable.", "Point to any github repo with scarpet apps", "using <user>/<repo>/contents/<path...>"}, category={"scarpet"}, strict=false, validate={AppStoreManager.ScarpetAppStoreValidator.class})
    public static String scriptsAppStore = "gnembon/scarpet/contents/programs";
    @Rule(desc="Enables /player command to control/spawn players", category={"command"})
    public static String commandPlayer = "ops";
    @Rule(desc="Spawn offline players in online mode if online-mode player with specified name does not exist", category={"command"})
    public static boolean allowSpawningOfflinePlayers = true;
    @Rule(desc="Allows to track mobs AI via /track command", category={"command"})
    public static String commandTrackAI = "ops";
    @Rule(desc="Placing carpets may issue carpet commands for non-op players", category={"survival"})
    public static boolean carpets = false;
    @Rule(desc="Glass can be broken faster with pickaxes", category={"survival"})
    public static boolean missingTools = false;
    @Rule(desc="fill/clone/setblock and structure blocks cause block updates", category={"creative"})
    public static boolean fillUpdates = true;
    @Rule(desc="placing blocks cause block updates", category={"creative"})
    public static boolean interactionUpdates = true;
    @Rule(desc="Disables breaking of blocks caused by flowing liquids", category={"creative"})
    public static boolean liquidDamageDisabled = false;
    @Rule(desc="smooth client animations with low tps settings", extra={"works only in SP, and will slow down players"}, category={"creative", "survival", "client"})
    public static boolean smoothClientAnimations;
    @Rule(desc="Customizable piston push limit", options={"10", "12", "14", "100"}, category={"creative"}, strict=false, validate={PushLimitLimits.class})
    public static int pushLimit;
    @Rule(desc="Customizable powered rail power range", options={"9", "15", "30"}, category={"creative"}, strict=false, validate={PushLimitLimits.class})
    public static int railPowerLimit;
    @Rule(desc="Customizable fill/clone volume limit", options={"32768", "250000", "1000000"}, category={"creative"}, strict=false, validate={FillLimitLimits.class})
    public static int fillLimit;
    @Rule(desc="Customizable forceload chunk limit", options={"256"}, category={"creative"}, strict=false, validate={FillLimitLimits.class})
    public static int forceloadLimit;
    @Rule(desc="Customizable maximal entity collision limits, 0 for no limits", options={"0", "1", "20"}, category={"optimization"}, strict=false, validate={Validators.NonNegativeNumber.class})
    public static int maxEntityCollisions;
    @Rule(desc="Customizable server list ping (Multiplayer menu) playerlist sample limit", options={"0", "12", "20", "40"}, category={"creative"}, strict=false, validate={Validators.NonNegativeNumber.class})
    public static int pingPlayerListLimit;
    @Rule(desc="Sets a different motd message on client trying to connect to the server", extra={"use '_' to use the startup setting from server.properties"}, options={"_"}, strict=false, category={"creative"})
    public static String customMOTD;
    @Rule(desc="Cactus in dispensers rotates blocks.", extra={"Rotates block anti-clockwise if possible"}, category={"feature", "dispenser"})
    public static boolean rotatorBlock;
    @Rule(desc="Changes the view distance of the server.", extra={"Set to 0 to not override the value in server settings."}, options={"0", "12", "16", "32"}, category={"creative"}, strict=false, validate={ViewDistanceValidator.class})
    public static int viewDistance;
    @Rule(desc="Changes the simulation distance of the server.", extra={"Set to 0 to not override the value in server settings."}, options={"0", "12", "16", "32"}, category={"creative"}, strict=false, validate={SimulationDistanceValidator.class})
    public static int simulationDistance;
    @Rule(desc="Changes size of spawn chunks", extra={"Defines new radius", "setting it to 0 - disables spawn chunks"}, category={"creative"}, strict=false, options={"0", "11"}, validate={ChangeSpawnChunksValidator.class})
    public static int spawnChunksSize;
    @Rule(desc="Changes maximum light tasks batch size", extra={"Allows for a higher light suppression tolerance", "setting it to 5 - Default limit defined by the game"}, category={"experimental", "optimization"}, strict=false, options={"5", "50", "100", "200"}, validate={LightBatchValidator.class})
    public static int lightEngineMaxBatchSize;
    @Rule(desc="Coral structures will grow with bonemeal from coral plants", extra={"Expanded also allows growing from coral fans for sustainable farming outside of warm oceans"}, category={"feature"})
    public static RenewableCoralMode renewableCoral;
    @Rule(desc="Nether basalt generator without soul sand below ", extra={"  .. will convert into blackstone instead"}, category={"feature"})
    public static boolean renewableBlackstone;
    @Rule(desc="Lava and water generate deepslate and cobbled deepslate instead below Y0", category={"feature"})
    public static boolean renewableDeepslate;
    @Rule(desc="fixes block placement rotation issue when player rotates quickly while placing blocks", category={"bugfix"})
    public static boolean placementRotationFix;
    @Rule(desc="Fixes leads breaking/becoming invisible in unloaded chunks", extra={"You may still get visibly broken leash links on the client side, but server side the link is still there."}, category={"bugfix"})
    public static boolean leadFix;
    @Rule(desc="Spawning requires much less CPU and Memory", category={"optimization"})
    public static boolean lagFreeSpawning;
    @Rule(desc="Allows structure mobs to spawn in flat worlds", category={"experimental", "creative"})
    public static boolean flatWorldStructureSpawning;
    @Rule(desc="Increases for testing purposes number of blue skulls shot by the wither", category={"creative"})
    public static boolean moreBlueSkulls;
    @Rule(desc="Removes fog from client in the nether and the end", extra={"Improves visibility, but looks weird"}, category={"client"})
    public static boolean fogOff;
    @Rule(desc="Creative No Clip", extra={"On servers it needs to be set on both ", "client and server to function properly.", "Has no effect when set on the server only", "Can allow to phase through walls", "if only set on the carpet client side", "but requires some trapdoor magic to", "allow the player to enter blocks"}, category={"creative", "client"})
    public static boolean creativeNoClip;
    @Rule(desc="Creative flying speed multiplier", extra={"Purely client side setting, meaning that", "having it set on the decicated server has no effect", "but this also means it will work on vanilla servers as well"}, category={"creative", "client"}, strict=false, validate={Validators.NonNegativeNumber.class})
    public static double creativeFlySpeed;
    @Rule(desc="Creative air drag", extra={"Increased drag will slow down your flight", "So need to adjust speed accordingly", "With 1.0 drag, using speed of 11 seems to matching vanilla speeds.", "Purely client side setting, meaning that", "having it set on the decicated server has no effect", "but this also means it will work on vanilla servers as well"}, category={"creative", "client"}, strict=false, validate={Validators.Probablity.class})
    public static double creativeFlyDrag;
    @Rule(desc="Removes obnoxious messages from the logs", extra={"Doesn't display 'Maximum sound pool size 247 reached'", "Which is normal with decent farms and contraptions"}, category={"survival", "client"})
    public static boolean cleanLogs;
    @Rule(desc="Customizable structure block limit of each axis", extra={"WARNING: Needs to be permanent for correct loading.", "Setting 'structureBlockIgnored' to air is recommended", "when saving massive structures.", "Required on client of player editing the Structure Block.", "'structureBlockOutlineDistance' may be required for", "correct rendering of long structures."}, options={"48", "96", "192", "256"}, category={"creative"}, validate={StructureBlockLimitValidator.class}, strict=false)
    public static int structureBlockLimit;
    @Rule(desc="Changes the block ignored by the Structure Block", options={"minecraft:structure_void", "minecraft:air"}, category={"creative"}, validate={StructureBlockIgnoredValidator.class}, strict=false)
    public static String structureBlockIgnored;
    @Rule(desc="Customizable Structure Block outline render distance", extra={"Required on client to work properly"}, options={"96", "192", "2048"}, category={"creative", "client"}, strict=false, validate={Validators.NonNegativeNumber.class})
    public static int structureBlockOutlineDistance;
    @Rule(desc="Lightning kills the items that drop when lightning kills an entity", extra={"Setting to true will prevent lightning from killing drops", "Fixes [MC-206922](https://bugs.mojang.com/browse/MC-206922)."}, category={"bugfix"})
    public static boolean lightningKillsDropsFix;
    @Rule(desc="Placing an activator rail on top of a barrier block will fill the neighbor updater stack when the rail turns off.", extra={"The integer entered is the amount of updates that should be left in the stack", "-1 turns it off"}, category={"creative"}, options={"-1", "0", "10", "50"}, strict=false, validate={UpdateSuppressionBlockModes.class})
    public static int updateSuppressionBlock;
    @Rule(desc="Creative players load chunks, or they don't! Just like spectators!", extra={"Toggling behaves exactly as if the player is in spectator mode and toggling the gamerule spectatorsGenerateChunks."}, category={"creative", "feature"})
    public static boolean creativePlayersLoadChunks;
    @Rule(desc="Customizable sculk sensor range", options={"8", "16", "32"}, category={"creative"}, strict=false, validate={PushLimitLimits.class})
    public static int sculkSensorRange;

    public static boolean isCreativeFlying(class_1297 entity) {
        return creativeNoClip && entity instanceof class_1657 && ((class_1657)entity).method_7337() && ((class_1657)entity).method_31549().field_7479;
    }

    static {
        pushLimit = 12;
        railPowerLimit = 9;
        fillLimit = 32768;
        forceloadLimit = 256;
        maxEntityCollisions = 0;
        pingPlayerListLimit = 12;
        customMOTD = "_";
        rotatorBlock = false;
        viewDistance = 0;
        simulationDistance = 0;
        spawnChunksSize = 11;
        lightEngineMaxBatchSize = 5;
        renewableCoral = RenewableCoralMode.FALSE;
        renewableBlackstone = false;
        renewableDeepslate = false;
        placementRotationFix = false;
        leadFix = false;
        lagFreeSpawning = false;
        flatWorldStructureSpawning = false;
        moreBlueSkulls = false;
        fogOff = false;
        creativeNoClip = false;
        creativeFlySpeed = 1.0;
        creativeFlyDrag = 0.09;
        cleanLogs = false;
        structureBlockLimit = 48;
        structureBlockIgnored = "minecraft:structure_void";
        structureBlockOutlineDistance = 96;
        lightningKillsDropsFix = false;
        updateSuppressionBlock = -1;
        creativePlayersLoadChunks = true;
        sculkSensorRange = 8;
    }

    public static enum RenewableCoralMode {
        FALSE,
        EXPANDED,
        TRUE;

    }

    private static class UpdateSuppressionBlockModes
    extends Validator<Integer> {
        private UpdateSuppressionBlockModes() {
        }

        @Override
        public Integer validate(class_2168 source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            return newValue < -1 ? null : newValue;
        }

        @Override
        public String description() {
            return "This value represents the amount of updates required before the logger logs them. Must be -1 or larger";
        }
    }

    public static class StructureBlockIgnoredValidator
    extends Validator<String> {
        @Override
        public String validate(class_2168 source, CarpetRule<String> currentRule, String newValue, String string) {
            Optional ignoredBlock = class_2378.field_11146.method_17966(class_2960.method_12829((String)newValue));
            if (!ignoredBlock.isPresent()) {
                Messenger.m(source, "r Unknown block '" + newValue + "'.");
                return null;
            }
            structureBlockIgnoredBlock = (class_2248)ignoredBlock.get();
            return newValue;
        }
    }

    public static class StructureBlockLimitValidator
    extends Validator<Integer> {
        @Override
        public Integer validate(class_2168 source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            return newValue >= 48 ? newValue : null;
        }

        @Override
        public String description() {
            return "You have to choose a value greater or equal to 48";
        }
    }

    public static class LightBatchValidator
    extends Validator<Integer> {
        public static void applyLightBatchSizes(int maxBatchSize) {
            for (class_3218 serverWorld : CarpetServer.minecraft_server.method_3738()) {
                serverWorld.method_14178().method_17293().method_17304(maxBatchSize);
            }
        }

        @Override
        public Integer validate(class_2168 source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            if (source == null) {
                return newValue;
            }
            if (newValue < 0) {
                Messenger.m(source, "r light batch size has to be at least 0");
                return null;
            }
            if (currentRule.value().intValue() == newValue.intValue()) {
                return newValue;
            }
            if (CarpetServer.minecraft_server == null) {
                return newValue;
            }
            LightBatchValidator.applyLightBatchSizes(newValue);
            return newValue;
        }
    }

    public static class ChangeSpawnChunksValidator
    extends Validator<Integer> {
        public static void changeSpawnSize(int size) {
            class_3218 overworld = CarpetServer.minecraft_server.method_3847(class_1937.field_25179);
            if (overworld != null) {
                class_1923 centerChunk = new class_1923(new class_2338(overworld.method_8401().method_215(), overworld.method_8401().method_144(), overworld.method_8401().method_166()));
                SpawnChunks.changeSpawnChunks(overworld.method_14178(), centerChunk, size);
            }
        }

        @Override
        public Integer validate(class_2168 source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            if (source == null) {
                return newValue;
            }
            if (newValue < 0 || newValue > 32) {
                Messenger.m(source, "r spawn chunk size has to be between 0 and 32");
                return null;
            }
            if (currentRule.value().intValue() == newValue.intValue()) {
                return newValue;
            }
            if (CarpetServer.minecraft_server == null) {
                return newValue;
            }
            class_3218 currentOverworld = CarpetServer.minecraft_server.method_3847(class_1937.field_25179);
            if (currentOverworld != null) {
                ChangeSpawnChunksValidator.changeSpawnSize(newValue);
            }
            return newValue;
        }
    }

    private static class SimulationDistanceValidator
    extends Validator<Integer> {
        private SimulationDistanceValidator() {
        }

        @Override
        public Integer validate(class_2168 source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            if (currentRule.value().equals(newValue) || source == null) {
                return newValue;
            }
            if (newValue < 0 || newValue > 32) {
                Messenger.m(source, "r simulation distance has to be between 0 and 32");
                return null;
            }
            MinecraftServer server = source.method_9211();
            if (server.method_3816()) {
                int vd;
                int n = vd = newValue >= 2 ? newValue : ((class_3176)server).method_16705().field_34883;
                if (vd != server.method_3760().method_38651()) {
                    server.method_3760().method_38650(vd);
                }
                return newValue;
            }
            Messenger.m(source, "r simulation distance can only be changed on a server");
            return 0;
        }

        @Override
        public String description() {
            return "You must choose a value from 0 (use server settings) to 32";
        }
    }

    private static class ViewDistanceValidator
    extends Validator<Integer> {
        private ViewDistanceValidator() {
        }

        @Override
        public Integer validate(class_2168 source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            if (currentRule.value().equals(newValue) || source == null) {
                return newValue;
            }
            if (newValue < 0 || newValue > 32) {
                Messenger.m(source, "r view distance has to be between 0 and 32");
                return null;
            }
            MinecraftServer server = source.method_9211();
            if (server.method_3816()) {
                int vd;
                int n = vd = newValue >= 2 ? newValue : ((class_2994)server).method_16705().field_16844;
                if (vd != server.method_3760().method_14568()) {
                    server.method_3760().method_14608(vd);
                }
                return newValue;
            }
            Messenger.m(source, "r view distance can only be changed on a server");
            return 0;
        }

        @Override
        public String description() {
            return "You must choose a value from 0 (use server settings) to 32";
        }
    }

    private static class FillLimitLimits
    extends Validator<Integer> {
        private FillLimitLimits() {
        }

        @Override
        public Integer validate(class_2168 source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            return newValue > 0 && newValue <= 20000000 ? newValue : null;
        }

        @Override
        public String description() {
            return "You must choose a value from 1 to 20M";
        }
    }

    private static class PushLimitLimits
    extends Validator<Integer> {
        private PushLimitLimits() {
        }

        @Override
        public Integer validate(class_2168 source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            return newValue > 0 && newValue <= 1024 ? newValue : null;
        }

        @Override
        public String description() {
            return "You must choose a value from 1 to 1024";
        }
    }

    private static class ModulePermissionLevel
    extends Validator<String> {
        private ModulePermissionLevel() {
        }

        @Override
        public String validate(class_2168 source, CarpetRule<String> currentRule, String newValue, String string) {
            int permissionLevel = switch (newValue) {
                case "false" -> 0;
                case "true", "ops" -> 2;
                case "0", "1", "2", "3", "4" -> Integer.parseInt(newValue);
                default -> throw new IllegalArgumentException();
            };
            if (source != null && !source.method_9259(permissionLevel)) {
                return null;
            }
            runPermissionLevel = permissionLevel;
            if (source != null) {
                CommandHelper.notifyPlayersCommandsChanged(source.method_9211());
            }
            return newValue;
        }

        @Override
        public String description() {
            return "When changing the rule, you must at least have the permission level you are trying to give it";
        }
    }

    private static class ChainStoneSetting
    extends Validator<String> {
        private ChainStoneSetting() {
        }

        @Override
        public String validate(class_2168 source, CarpetRule<String> currentRule, String newValue, String string) {
            doChainStone = !newValue.toLowerCase(Locale.ROOT).equals("false");
            chainStoneStickToAll = newValue.toLowerCase(Locale.ROOT).equals("stick_to_all");
            return newValue;
        }
    }

    private static class TNTAngleValidator
    extends Validator<Double> {
        private TNTAngleValidator() {
        }

        @Override
        public Double validate(class_2168 source, CarpetRule<Double> currentRule, Double newValue, String string) {
            return newValue >= 0.0 && newValue < Math.PI * 2 || newValue == -1.0 ? newValue : null;
        }

        @Override
        public String description() {
            return "Must be between 0 and 2pi, or -1";
        }
    }

    private static class TNTRandomRangeValidator
    extends Validator<Double> {
        private TNTRandomRangeValidator() {
        }

        @Override
        public Double validate(class_2168 source, CarpetRule<Double> currentRule, Double newValue, String string) {
            return newValue == -1.0 || newValue >= 0.0 ? newValue : null;
        }

        @Override
        public String description() {
            return "Cannot be negative, except for -1";
        }
    }

    private static class CheckOptimizedTntEnabledValidator<T>
    extends Validator<T> {
        private CheckOptimizedTntEnabledValidator() {
        }

        @Override
        public T validate(class_2168 source, CarpetRule<T> currentRule, T newValue, String string) {
            return (T)(optimizedTNT || currentRule.defaultValue().equals(newValue) ? newValue : null);
        }

        @Override
        public String description() {
            return "optimizedTNT must be enabled";
        }
    }

    public static class StackableShulkerBoxValidator
    extends Validator<String> {
        @Override
        public String validate(class_2168 source, CarpetRule<String> currentRule, String newValue, String string) {
            int value;
            if (newValue.matches("^[0-9]+$") && (value = Integer.parseInt(newValue)) <= 64 && value >= 2) {
                shulkerBoxStackSize = value;
                return newValue;
            }
            if (newValue.equalsIgnoreCase("false")) {
                shulkerBoxStackSize = 1;
                return newValue;
            }
            if (newValue.equalsIgnoreCase("true")) {
                shulkerBoxStackSize = 64;
                return newValue;
            }
            return null;
        }

        @Override
        public String description() {
            return "Value must either be true, false, or a number between 2-64";
        }
    }

    private static class OneHourMaxDelayLimit
    extends Validator<Integer> {
        private OneHourMaxDelayLimit() {
        }

        @Override
        public Integer validate(class_2168 source, CarpetRule<Integer> currentRule, Integer newValue, String string) {
            return newValue > 0 && newValue <= 72000 ? newValue : null;
        }

        @Override
        public String description() {
            return "You must choose a value from 1 to 72000";
        }
    }

    private static class CarpetPermissionLevel
    extends Validator<String> {
        private CarpetPermissionLevel() {
        }

        @Override
        public String validate(class_2168 source, CarpetRule<String> currentRule, String newValue, String string) {
            if (source == null || source.method_9259(4)) {
                return newValue;
            }
            return null;
        }

        @Override
        public String description() {
            return "This setting can only be set by admins with op level 4";
        }
    }

    private static class LanguageValidator
    extends Validator<String> {
        private LanguageValidator() {
        }

        @Override
        public String validate(class_2168 source, CarpetRule<String> currentRule, String newValue, String string) {
            if (!Translations.isValidLanguage(newValue)) {
                Messenger.m(source, "r " + newValue + " is not a valid language");
                return null;
            }
            language = newValue;
            Translations.updateLanguage();
            return newValue;
        }
    }
}

